/*  Prüft die Einträge der Tabelle "scheduling.resource_timeline" auf logische Inkonsistenzen.
    Diese sollten nie auftreten. Wenn doch, dann haben wir einen Fehler om Algorithmus.
    Für jeden Typ gibt es eine eigene Unterfunktion.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__validate_block', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block(
    _rt_block scheduling.resource_timeline
    )
    RETURNS jsonb AS $$
    DECLARE

    BEGIN

        CASE _rt_block.ti_type
        WHEN 'task' THEN
            RETURN scheduling.resource_timeline__validate_block_task( _rt_block );

        WHEN 'task.blocktime' THEN
            RETURN scheduling.resource_timeline__validate_block_task_blocktime( _rt_block );

        WHEN 'off' THEN
            RETURN scheduling.resource_timeline__validate_block_off( _rt_block );

        WHEN 'off.day' THEN
            RETURN scheduling.resource_timeline__validate_block_off_day( _rt_block );

        WHEN 'off.time' THEN
            RETURN scheduling.resource_timeline__validate_block_off_time( _rt_block );

        WHEN 'task.buffer' THEN -- puffer KEINE Validate-Prüfung -- TODO AXS: Validierung für Puffer implementieren (ähnlich, wie für 'task'-Einträge).
            RETURN null::jsonb;

        ELSE
            -- default case
            RAISE EXCEPTION 'FUNCTION scheduling.resource_timeline__validate_block: unknown block with id % (ti_type=%)', _resource_timeline_id, _rt_block;
        END CASE;

    END $$ LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block(
    _resource_timeline_id int
    )
    RETURNS jsonb
    AS $$

        SELECT scheduling.resource_timeline__validate_block(resource_timeline)
          FROM scheduling.resource_timeline
         WHERE ti_id = _resource_timeline_id;

    $$ LANGUAGE sql STABLE;
